<?php

/**
 * @file
 * Convenience file that registers autoload handler for HTML Purifier.
 * It also does some sanity checks.
 */


HTMLPurifier_Bootstrap::registerAutoload();
if(function_exists('__autoload')) {
	// Be polite and ensure that userland autoload gets retained
	spl_autoload_register('__autoload');
}

if(ini_get('zend.ze1_compatibility_mode')) {
	trigger_error("HTML Purifier is not compatible with zend.ze1_compatibility_mode; please turn it off", E_USER_ERROR);
}

// vim: et sw=4 sts=4
